import java.awt.Frame;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Font;
import java.io.*;
import java.io.IOException;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;


import com.melloware.jintellitype.HotkeyListener;
import com.melloware.jintellitype.IntellitypeListener;
import com.melloware.jintellitype.JIntellitype;


public class PlaylistSwitcher extends JFrame implements HotkeyListener, IntellitypeListener {
	private static final long serialVersionUID = 1L;
   private static PlaylistSwitcher mainFrame;
   private static  String WINAMPPFAD = "c:\\programme\\winamp\\winamp.exe";
   private static final int K1 = 93;
   private static final int KPLUS = 92;
   private static final int KMINUS = 91;
   private static int pointer = K1;
   private JPanel mainPanel = new JPanel();
   private JPanel centerPanel = new JPanel();
   private JPanel subPanel = new JPanel();
   private JLabel sender=new JLabel(".");
   private JPanel senderliste=new JPanel();
   private String last="";
   private File f;
   private String [] s;
   private Character [] tastatur = {'1','2','3','4','5','6','7','8','9','0','Q','W','E','R','T','Z','U','I','O','P','A','S','D','F','G','H','J','K','L','Y','X','C','V','B','N','M'};

   /**
    * Creates new form.
    */
   public PlaylistSwitcher() {
      initComponents();
   }



   public void onHotKey(int aIdentifier) {
	   try {
	   if (aIdentifier>92){

		   	  sender.setText(s[aIdentifier-K1]);
		      Runtime.getRuntime().exec( WINAMPPFAD+" \""+f.getAbsolutePath()+"\\"+s[aIdentifier-K1]+"\"" );
		     last=s[aIdentifier-K1]; Save();
		     pointer=aIdentifier;


	}
	if (aIdentifier==KPLUS){
		pointer++;
		if (pointer-K1>=s.length-1){
			pointer=K1;
		}
		sender.setText(s[pointer-K1]);
		Runtime.getRuntime().exec( WINAMPPFAD+" \""+f.getAbsolutePath()+"\\"+s[pointer-K1]+"\"" );
		last=s[pointer-K1]; Save();
	}
	if (aIdentifier==KMINUS){
		pointer--;
		if (pointer<K1){
			pointer=K1+s.length-1;
		}
		sender.setText(s[pointer-K1]);
		Runtime.getRuntime().exec( WINAMPPFAD+" \""+f.getAbsolutePath()+"\\"+s[pointer-K1]+"\"" );
		last=s[pointer-K1]; Save();
	}
	} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
	}

   }



   /**
    * Centers window on desktop.
    * <p>
    * @param aFrame the Frame to center
    */
   private static void center(JFrame aFrame) {

      final GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
      final Point centerPoint = ge.getCenterPoint();
      final Rectangle bounds = ge.getMaximumWindowBounds();
      final int w = Math.min(aFrame.getWidth(), bounds.width);
      final int h = Math.min(aFrame.getHeight(), bounds.height);
      final int x = centerPoint.x - (200);
      final int y = centerPoint.y - (100);
      aFrame.setBounds(x, y, w, h);
      if ((w == bounds.width) && (h == bounds.height)) {
         aFrame.setExtendedState(Frame.MAXIMIZED_BOTH);
      }
      aFrame.validate();
   }




   /**
    * This method is called from within the constructor to initialize the form.
    */
   private void initComponents() {
	   	Font font = new Font("Dialog", Font.PLAIN, 24);
	   	sender.setFont(font);
		mainPanel.setBackground(new Color(197,0,28));
		centerPanel.add(sender);
		senderliste.setLayout( new GridLayout(0, 3,2,2) );
		subPanel.add(senderliste);
		centerPanel.setBackground(new Color(197,0,28));
		subPanel.setBackground(new Color(197,0,28));
		senderliste.setForeground(new Color (254,234,192));
		sender.setForeground(new Color (254,234,192));

		mainPanel.setLayout(new BorderLayout());
      	mainPanel.add(centerPanel,BorderLayout.CENTER);
      	mainPanel.add(subPanel,BorderLayout.SOUTH);


       f = new File("playlists\\");
       s = f.list();
      for (int i=0;i<s.length;i++){
    	  if(i>tastatur.length)
    		  break;
    	  JIntellitype.getInstance().registerHotKey(K1+i, 0, (int)tastatur[i]);
    	  senderliste.add(new JLabel(" "+tastatur[i]+" - "+s[i]));
      }
      	JIntellitype.getInstance().registerHotKey(KPLUS, 0, 107);
      	JIntellitype.getInstance().registerHotKey(KMINUS, 0, 109);
		Load();


      this.addWindowListener(new java.awt.event.WindowAdapter() {
         public void windowClosing(java.awt.event.WindowEvent evt) {
            // don't forget to clean up any resources before close
        	 for (int i=0;i<s.length;i++){
        		 if(i>tastatur.length)
           		  break;
        		 JIntellitype.getInstance().unregisterHotKey(K1+i);
        	 }
        	 JIntellitype.getInstance().unregisterHotKey(KPLUS);
        	 JIntellitype.getInstance().unregisterHotKey(KMINUS);
            JIntellitype.getInstance().cleanUp();
            System.exit(0);
         }
      });

      this.getContentPane().add(mainPanel);
      this.pack();
      //this.setSize(200, 150);
   }

   /**
    * Initialize the JInitellitype library making sure the DLL is located.
    *
    */
   public void initJIntellitype() {
      try {

         // initialize JIntellitype with the frame so all windows commands can
         // be attached to this window
         JIntellitype.getInstance().addHotKeyListener(this);
         JIntellitype.getInstance().addIntellitypeListener(this);
      } catch (RuntimeException ex) {
         System.out.println("Either you are not on Windows, or there is a problem with the JIntellitype library!");

      }
   }


@Override
public void onIntellitype(int arg0) {
	// TODO Auto-generated method stub

}
public void Save(){
	try{
	BufferedWriter bw = new BufferedWriter(
		new OutputStreamWriter(
			new FileOutputStream("PlaylistSwitcher.ini")));
	bw.write(WINAMPPFAD);
	bw.write("\n");
	bw.write(last);
	bw.close();
	}catch (Exception e){};
}
public void Load(){
	try{
	BufferedReader br = new BufferedReader(
	new InputStreamReader(
	new FileInputStream("PlaylistSwitcher.ini")));
	WINAMPPFAD=br.readLine();
	last=br.readLine();
	br.close();
	sender.setText(last);
	Runtime.getRuntime().exec( WINAMPPFAD+" \""+f.getAbsolutePath()+"\\"+last+"\"" );
	}catch (Exception e){
		WINAMPPFAD = "c:\\programme\\winamp\\winamp.exe";
		last="";
		};

}

	public static void main(String[] args) {
		// first check to see if an instance of this application is already
	    // running, use the name of the window title of this JFrame for checking
	    if (JIntellitype.checkInstanceAlreadyRunning("Playlist Switcher")) {
	       System.out.println("An instance of this application is already running");
	       System.exit(1);
	    }

	    // next check to make sure JIntellitype DLL can be found and we are on
	    // a Windows operating System
	    if (!JIntellitype.isJIntellitypeSupported()) {
	  	  System.out.println("JIntellitype.DLL is not found in the path or this is not Windows 32bit OS.");
	       System.exit(1);
	    }

	    mainFrame = new PlaylistSwitcher();
	    mainFrame.setTitle("Playlist Switcher");
	    center(mainFrame);
	    mainFrame.setVisible(true);
	    mainFrame.initJIntellitype();

	}

}
